#!/usr/bin/bash

module purge
module add compiler/intel/18.0
module add mpi/impi/2018-intel-18.0
module add devel/cmake/3.14.0
module add devel/itac/2018

# Configure build flags
export CFLAGS="-Ofast -xHost"

# Add trace flags

# -tcollect
#          inserts instrumentation probes calling the Intel(R) Trace Collector
#          API.

# -trace
#          Use the -t or -trace option to link the resulting executable file
#          against the Intel(R) Trace Collector library.

# -g
#          Produce symbolic debug information.
CFLAGS+=" -tcollect -trace -g"

rm --verbose --force CMakeCache.txt
cmake -DCMAKE_C_COMPILER=mpiicc -DCMAKE_EXECUTABLE_SUFFIX_C=.itac .

make clean
make
